/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;

public class IPAddressTextField
extends TextFieldWidget {
    private final int defaultPort;

    public IPAddressTextField(FontRenderer textRenderer, int x, int y, int width, int height, ITextComponent name, int defaultPort) {
        super(textRenderer, x, y, width, height, name);
        this.defaultPort = defaultPort;
        this.func_146180_a(String.valueOf(defaultPort));
        this.func_212954_a(text -> this.func_146193_g(IPAddressTextField.validatePort(text) >= 0 ? 0xFFFFFF : 0xFF0000));
    }

    public int getServerPort() {
        String portStr = this.func_146179_b();
        return portStr.length() > 0 ? Integer.parseInt(portStr) : this.defaultPort;
    }

    public static int validatePort(String text) {
        boolean valid = true;
        int port = -1;
        try {
            if (text.length() > 0 && ((port = Integer.parseInt(text)) < 0 || port > 65535)) {
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid ? port : -1;
    }
}

